﻿using System;
using System.Collections.Generic;
using System.Linq;
using BMS.VistaIntegration.Data;
using Mdws2ORM;
using Mdws2ORM.Core;

namespace BMS.VistaIntegration.Via.Commands
{
    public abstract class BaseSingleCommand<T> : BaseCommand<T> where T : class, IEntity
    {
        protected BaseSingleCommand(ViaVistAQuery query)
            : base(query)
        {
        }

        public string Ien
        {
            get;
            set;
        }

        protected override List<T> GetEntitiesFromData(ViaVistASession session)
        {
            Func<List<T>> func = () =>
            {

                var dictionary = this.GetSectionsFromVia(session).SingleOrDefault().Value;
                if (dictionary != null)
                {
                    var lines = dictionary["Data"];

                    if (lines != null && lines.Count > 0)
                    {
                        var mappedFieldIens = this.EntityMap.AllFields.Select(x => x.Field);
                        var entry = ProcessLines(this.EntityMap.GetQueryParam, lines, mappedFieldIens);

                        this.PrepareCache(session.VistASite, new List<Entry> { entry });
                        return new List<T>() { this.GetEntity(entry, this.EntityMap, "") };
                    }
                }

                return null;
            };

            return this.VistAQuery.EntitySetCache.RunThroghCache<T>(func);
        }

        protected override IEnumerable<object> GetCriteria()
        {
            yield return this.Ien;
            yield return string.Empty;
        }

        private static Entry ProcessLines(QueryParam queryParam, IList<string> lines, IEnumerable<string> mappedFieldIens)
        {
            var splitLines = from line in lines
                             select line.Split('^');

            // Perform an left outter join of mappedFieldIens with lines to match the fields by count as well as order
            var fields = (from field in mappedFieldIens
                          join line in splitLines on field equals line[2] into fieldLines
                          from values in fieldLines.DefaultIfEmpty()
                          select new Entry.Field(field, values == null ? null : values[3])).ToArray();

            var ien = lines[0].Split('^')[1];
            return new Entry(queryParam.File, ien, fields);
        }
    }
}
